COMMENT:  This code attempts to replicate results of Figures 11-1 through 11-7, the covariates have zero means.
COMMENT:  the KR corrections are built in to the Repeated Statement, and a Weight statement is not used.
COMMENT: the models seem to estimate properly given the SAS covariance structures.
COMMENT: rpost is the reversed coding of post, rpost zero is post period, rpost 1 is pre period, 
	the estimates are easier to read this way.
COMMENT: 	Treatment 1 is Conect, Treatment 2 is not matched, Treatment 3 is matched, the comparison group.
COMMENT: Syntax by Robert B Smith, copyright   2011.

Weight Off.

COMMENT: This code checks that the means of the covariates are zero, they are centered by grand means.
DATASET ACTIVATE DataSet1.
DESCRIPTIVES VARIABLES=year98 year99  lowstgrd locate targett1 safe STRatio femprob  blackp forredlp 
		MSAPPerform AveComp  
  /STATISTICS=MEAN STDDEV MIN MAX.

COMMENT: This syntax replicates the SAS runs when no variables are weighted, R-side random effects only.
COMMENT: This run replicates SAS run Fig 11-1 with KR built in, there are no G side random effects.
MIXED MSAPPerform BY Trt rpost WITH year98 year99 lowstgrd locate TargetT1 Safe STRatio femprob 
    Blackp ForRedLp
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED=Trt rpost Trt*rpost year98 year99 lowstgrd locate TargetT1 Safe STRatio femprob Blackp ForRedLp | SSTYPE(3)
  /METHOD=REML
  /PRINT=G  R SOLUTION TESTCOV
  /REPEATED=period | SUBJECT(Trt*School) COVTYPE(cs)
  /EMMEANS=TABLES(Trt*rpost) 
  /EMMEANS=TABLES(Trt) 
  /EMMEANS=TABLES(rpost) .

COMMENT: This run replicates the equivalent SAS run Fig 11-3 with KR built in; there are no G side random effects.
COMMENT: The covariates are mean centered without any weighting.
MIXED AveComp BY Trt rpost WITH year98 year99 lowstgrd locate TargetT1 Safe STRatio femprob 
    Blackp ForRedLp
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED=Trt rpost Trt*rpost year98 year99 lowstgrd locate TargetT1 Safe STRatio femprob Blackp ForRedLp | SSTYPE(3)
  /METHOD=REML
  /PRINT=G  R SOLUTION TESTCOV
  /REPEATED=period | SUBJECT(Trt*School) COVTYPE(cs)
  /EMMEANS=TABLES(Trt*rpost) 
  /EMMEANS=TABLES(Trt) 
  /EMMEANS=TABLES(rpost) .


COMMENT: This run replicates the equivalent SAS run Fig 11-4 with KR built in; there are no G side random effects.
COMMENT: The covariates are mean centered without any weighting.
MIXED GR3Comp BY Trt rpost WITH year98 year99 lowstgrd locate TargetT1 Safe STRatio femprob 
    Blackp ForRedLp
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED=Trt rpost Trt*rpost year98 year99 lowstgrd locate TargetT1 Safe STRatio femprob Blackp ForRedLp | SSTYPE(3)
  /METHOD=REML
  /PRINT=G  R SOLUTION TESTCOV
  /REPEATED=period | SUBJECT(Trt*School) COVTYPE(cs)
  /EMMEANS=TABLES(Trt*rpost) 
  /EMMEANS=TABLES(Trt) 
  /EMMEANS=TABLES(rpost) .



COMMENT: This run replicates the equivalent SAS run Fig 11-5 with KR built in; there are no G side random effects.
COMMENT: The covariates are mean centered without any weighting.
MIXED GR3Read BY Trt rpost WITH year98 year99 lowstgrd locate TargetT1 Safe STRatio femprob 
    Blackp ForRedLp
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED=Trt rpost Trt*rpost year98 year99 lowstgrd locate TargetT1 Safe STRatio femprob Blackp ForRedLp | SSTYPE(3)
  /METHOD=REML
  /PRINT=G  R SOLUTION TESTCOV
  /REPEATED=period | SUBJECT(Trt*School) COVTYPE(vc)
  /EMMEANS=TABLES(Trt*rpost) 
  /EMMEANS=TABLES(Trt) 
  /EMMEANS=TABLES(rpost) .



COMMENT: This run replicates the equivalent SAS run Fig 11-6 with KR built in; there are no G side random effects.
COMMENT: The covariates are mean centered without any weighting.
MIXED GR3Math BY Trt rpost WITH year98 year99 lowstgrd locate TargetT1 Safe STRatio femprob 
    Blackp ForRedLp
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED=Trt rpost Trt*rpost year98 year99 lowstgrd locate TargetT1 Safe STRatio femprob Blackp ForRedLp | SSTYPE(3)
  /METHOD=REML
  /PRINT=G  R SOLUTION TESTCOV
  /REPEATED=period | SUBJECT(Trt*School) COVTYPE(cs)
  /EMMEANS=TABLES(Trt*rpost) 
  /EMMEANS=TABLES(Trt) 
  /EMMEANS=TABLES(rpost) .


COMMENT: This run replicates the equivalent SAS run Fig 11-7 with KR built in; there are no G side random effects.
COMMENT: The covariates are mean centered without any weighting.
MIXED GR5Comp BY Trt rpost WITH year98 year99 lowstgrd locate TargetT1 Safe STRatio femprob 
    Blackp ForRedLp
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED=Trt rpost Trt*rpost year98 year99 lowstgrd locate TargetT1 Safe STRatio femprob Blackp ForRedLp | SSTYPE(3)
  /METHOD=REML
  /PRINT=G  R SOLUTION TESTCOV
  /REPEATED=period | SUBJECT(Trt*School) COVTYPE(cs)
  /EMMEANS=TABLES(Trt*rpost) 
  /EMMEANS=TABLES(Trt) 
  /EMMEANS=TABLES(rpost) .



COMMENT: This run replicates the equivalent SAS run Fig 11-8 with KR built in; there are no G side random effects.
COMMENT: The covariates are mean centered without any weighting.
MIXED GR5Read BY Trt rpost WITH year98 year99 lowstgrd locate TargetT1 Safe STRatio femprob 
    Blackp ForRedLp
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED=Trt rpost Trt*rpost year98 year99 lowstgrd locate TargetT1 Safe STRatio femprob Blackp ForRedLp | SSTYPE(3)
  /METHOD=REML
  /PRINT=G  R SOLUTION TESTCOV
  /REPEATED=period | SUBJECT(Trt*School) COVTYPE(csh)
  /EMMEANS=TABLES(Trt*rpost) 
  /EMMEANS=TABLES(Trt) 
  /EMMEANS=TABLES(rpost) .



COMMENT: This run replicates the equivalent SAS run Fig 11-9 with KR built in; there are no G side random effects.
COMMENT: The covariates are mean centered without any weighting.
MIXED GR5Math BY Trt rpost WITH year98 year99 lowstgrd locate TargetT1 Safe STRatio femprob 
    Blackp ForRedLp
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED=Trt rpost Trt*rpost year98 year99 lowstgrd locate TargetT1 Safe STRatio femprob Blackp ForRedLp | SSTYPE(3)
  /METHOD=REML
  /PRINT=G  R SOLUTION TESTCOV
  /REPEATED=period | SUBJECT(Trt*School) COVTYPE(cs)
  /EMMEANS=TABLES(Trt*rpost) 
  /EMMEANS=TABLES(Trt) 
  /EMMEANS=TABLES(rpost) .




